/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SpiritFlareEffect;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingOrBlockingCreature;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class SpiritFlare
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("untapped creature you control");
    private static final FilterPermanent filter2 = new FilterAttackingOrBlockingCreature("attacking or blocking creature an opponent controls");

    public SpiritFlare(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{W}");
        this.getSpellAbility().addEffect((Effect)new SpiritFlareEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addTarget((Target)new TargetPermanent(filter2));
        FlashbackAbility ability = new FlashbackAbility((Card)this, (Cost)new ManaCostsImpl("{1}{W}"));
        ability.addCost((Cost)new PayLifeCost(3));
        this.addAbility((Ability)ability);
    }

    private SpiritFlare(SpiritFlare card) {
        super((CardImpl)card);
    }

    public SpiritFlare copy() {
        return new SpiritFlare(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter2.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

