/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SpitfireHandlerCantBlockEffect
extends RestrictionEffect {
    SpitfireHandlerCantBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't block creatures with power greater than {this}'s power";
    }

    private SpitfireHandlerCantBlockEffect(SpitfireHandlerCantBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        if (attacker == null) {
            return true;
        }
        return blocker.getPower().getValue() >= attacker.getPower().getValue();
    }

    public SpitfireHandlerCantBlockEffect copy() {
        return new SpitfireHandlerCantBlockEffect(this);
    }
}

