/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.s.SplinteringWindDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SplinterToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class SplinteringWindCreateTokenEffect
extends OneShotEffect {
    SplinteringWindCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 1/1 green Splinter creature token. It has flying and \"Cumulative upkeep {G}.\" When it leaves the battlefield, it deals 1 damage to you and each creature you control";
    }

    private SplinteringWindCreateTokenEffect(SplinteringWindCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourceController = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceController != null && sourceObject != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new SplinterToken());
            effect.apply(game, source);
            game.getState().setValue(source.getSourceId() + "_token", (Object)effect.getLastAddedTokenIds());
            for (UUID addedTokenId : effect.getLastAddedTokenIds()) {
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new SplinteringWindDelayedTriggeredAbility(addedTokenId), source);
            }
            return true;
        }
        return false;
    }

    public SplinteringWindCreateTokenEffect copy() {
        return new SplinteringWindCreateTokenEffect(this);
    }
}

