/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.s.SporogenesisCount;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SporogenesisTriggeredAbility
extends TriggeredAbilityImpl {
    SporogenesisTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new SaprolingToken(), (DynamicValue)new SporogenesisCount()), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SporogenesisTriggeredAbility(SporogenesisTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SporogenesisTriggeredAbility copy() {
        return new SporogenesisTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && (permanent = game.getPermanentOrLKIBattlefield(zEvent.getTargetId())) != null && permanent.isCreature(game) && permanent.getCounters(game).containsKey(CounterType.FUNGUS)) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature with a fungus counter on it dies, create a 1/1 green Saproling creature token for each fungus counter on that creature.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

