/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DealtDamageAttachedTriggeredAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.s.SporogenicInfectionPredicate;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SetTargetPointer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetCreaturePermanent;

public final class SporogenicInfection
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a creature other than enchanted creature");

    public SporogenicInfection(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        EntersBattlefieldTriggeredAbility ability = new EntersBattlefieldTriggeredAbility((Effect)new SacrificeEffect(filter, 1, "target player").setText("target player sacrifices a creature of their choice other than enchanted creature"));
        ability.addTarget((Target)new TargetPlayer());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DealtDamageAttachedTriggeredAbility(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect().setText("destroy it"), false, SetTargetPointer.PERMANENT).setTriggerPhrase("When enchanted creature is dealt damage, "));
    }

    private SporogenicInfection(SporogenicInfection card) {
        super((CardImpl)card);
    }

    public SporogenicInfection copy() {
        return new SporogenicInfection(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)SporogenicInfectionPredicate.instance);
    }
}

