/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.InsectToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpringheartNantukoEffect
extends OneShotEffect {
    SpringheartNantukoEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may pay {1}{G} if {this} is attached to a creature you control. If you do, create a token that's a copy of that creature. If you didn't create a token this way, create a 1/1 green Insect creature token";
    }

    private SpringheartNantukoEffect(SpringheartNantukoEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpringheartNantukoEffect copy() {
        return new SpringheartNantukoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ManaCostsImpl cost;
        Permanent attachedTo;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent nantuko = game.getPermanent(source.getSourceId());
        if (nantuko != null && StaticFilters.FILTER_CONTROLLED_CREATURE.match(attachedTo = game.getPermanent(nantuko.getAttachedTo()), controller.getId(), source, game) && (cost = new ManaCostsImpl("{1}{G}")).canPay(source, source, controller.getId(), game) && controller.chooseUse(Outcome.PutCreatureInPlay, "Pay {1}{G} to make a copy of " + attachedTo.getIdName() + "?", source, game) && cost.pay(source, game, source, controller.getId(), false, null) && new CreateTokenCopyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(attachedTo, game)).apply(game, source)) {
            return true;
        }
        new CreateTokenEffect((Token)new InsectToken()).apply(game, source);
        return true;
    }
}

