/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CreaturesDiedThisTurnCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ConniveSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SpymastersVaultEffect
extends OneShotEffect {
    SpymastersVaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control connives X, where X is the number of creatures that died this turn";
    }

    private SpymastersVaultEffect(SpymastersVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpymastersVaultEffect copy() {
        return new SpymastersVaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int deaths = CreaturesDiedThisTurnCount.instance.calculate(game, source, (Effect)this);
        if (deaths < 1) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        return ConniveSourceEffect.connive((Permanent)permanent, (int)deaths, (Ability)source, (Game)game);
    }
}

