/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class StaffOfTheLetterMagusEffect
extends OneShotEffect {
    StaffOfTheLetterMagusEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain 1 life for each time the chosen letter appears in that spell's name";
    }

    private StaffOfTheLetterMagusEffect(StaffOfTheLetterMagusEffect effect) {
        super((OneShotEffect)effect);
    }

    public StaffOfTheLetterMagusEffect copy() {
        return new StaffOfTheLetterMagusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        MageObject mageObject;
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (controller != null && spell != null && (mageObject = game.getObject(source)) instanceof Permanent && (permanent = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && game.getState().getValue(mageObject.getId() + "_letter") != null) {
            int lifegainValue = 0;
            String spellName = spell.getName();
            for (int i = 0; i < spellName.length(); ++i) {
                char letter = spellName.charAt(i);
                String chosenLetter = (String)game.getState().getValue(mageObject.getId() + "_letter");
                if (chosenLetter == null || !Character.isLetter(letter) || Character.toUpperCase(letter) != chosenLetter.charAt(0)) continue;
                ++lifegainValue;
            }
            controller.gainLife(lifegainValue, game, source);
            return true;
        }
        return false;
    }
}

