/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseSecretOpponentEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StalkingLeoninEffect
extends OneShotEffect {
    StalkingLeoninEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature that's attacking you if it's controlled by the chosen player. Activate only once";
    }

    private StalkingLeoninEffect(StalkingLeoninEffect effect) {
        super((OneShotEffect)effect);
    }

    public StalkingLeoninEffect copy() {
        return new StalkingLeoninEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetCreature == null || !targetCreature.isControlledBy(ChooseSecretOpponentEffect.getChosenPlayer((Ability)source, (Game)game))) {
            return true;
        }
        controller.moveCards((Card)targetCreature, Zone.EXILED, source, game);
        return true;
    }
}

