/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.s.StalwartSuccessorWatcher;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StalwartSuccessorTriggeredAbility
extends TriggeredAbilityImpl {
    StalwartSuccessorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.setTriggerPhrase("Whenever one or more counters are put on a creature you control, if it's the first time counters have been put on that creature this turn, ");
        this.addWatcher(new StalwartSuccessorWatcher());
    }

    private StalwartSuccessorTriggeredAbility(StalwartSuccessorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public StalwartSuccessorTriggeredAbility copy() {
        return new StalwartSuccessorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int zccOffset = 0;
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
            zccOffset = 1;
        }
        if (!(permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId()) && StalwartSuccessorWatcher.checkCreature(permanent, event, game))) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game) + zccOffset));
        return true;
    }
}

