/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Arrays;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesSubtypeAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class StandardizeEffect
extends OneShotEffect {
    StandardizeEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "choose a creature type other than Wall. Each creature becomes that type until end of turn";
    }

    private StandardizeEffect(StandardizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            typeChoice.setMessage("Choose a creature type other than Wall");
            typeChoice.getKeyChoices().keySet().removeIf(c -> c.equals("Wall"));
            if (!player.choose(Outcome.BoostCreature, (Choice)typeChoice, game)) {
                return false;
            }
            game.informPlayers(sourceObject.getLogName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            game.addEffect((ContinuousEffect)new BecomesSubtypeAllEffect(Duration.EndOfTurn, Arrays.asList(SubType.byDescription((String)typeChoice.getChoiceKey())), StaticFilters.FILTER_PERMANENT_CREATURE, true), source);
            return true;
        }
        return false;
    }

    public StandardizeEffect copy() {
        return new StandardizeEffect(this);
    }
}

