/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.StanggTwinToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class StanggEchoWarriorEffect
extends OneShotEffect {
    StanggEchoWarriorEffect() {
        super(Outcome.Benefit);
        this.staticText = "create Stangg Twin, a legendary 3/4 red and green Human Warrior creature token. It enters the battlefield tapped and attacking. For each Aura and Equipment attached to {this}, create a token that's a copy of it attached to Stangg Twin. Sacrifice all tokens created this way at the beginning of the next end step";
    }

    private StanggEchoWarriorEffect(StanggEchoWarriorEffect effect) {
        super((OneShotEffect)effect);
    }

    public StanggEchoWarriorEffect copy() {
        return new StanggEchoWarriorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List<Permanent> tokens = StanggEchoWarriorEffect.makeTokens(game, source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets(tokens, game))), source);
        return true;
    }

    static List<Permanent> makeTokens(Game game, Ability source) {
        StanggTwinToken token = new StanggTwinToken();
        token.putOntoBattlefield(1, game, source, source.getControllerId(), true, true);
        List<Permanent> toSacrifice = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return toSacrifice;
        }
        Set attachments = sourcePermanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(p -> p.hasSubtype(SubType.AURA, game) || p.hasSubtype(SubType.EQUIPMENT, game)).collect(Collectors.toSet());
        if (attachments.isEmpty()) {
            return toSacrifice;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            for (Permanent attachment : attachments) {
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
                effect.setSavedPermanent(attachment);
                effect.setAttachedTo(tokenId);
                effect.apply(game, source);
                toSacrifice.addAll(effect.getAddedPermanents());
            }
        }
        return toSacrifice;
    }
}

