/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StarAthleteEffect
extends OneShotEffect {
    StarAthleteEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target nonland permanent. Its controller may sacrifice it. If they don't, {this} deals 5 damage to that player";
    }

    private StarAthleteEffect(StarAthleteEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarAthleteEffect copy() {
        return new StarAthleteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        return player != null && (permanent.canBeSacrificed() && player.chooseUse(this.outcome, "Sacrifice " + permanent.getName() + " or take 5 damage?", null, "Sacrifce", "Take 5 damage", source, game) && permanent.sacrifice(source, game) || player.damage(5, source, game) > 0);
    }
}

