/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StasisFieldEffect
extends ContinuousEffectImpl {
    StasisFieldEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = ", has defender, and loses all other abilities";
    }

    private StasisFieldEffect(StasisFieldEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public StasisFieldEffect copy() {
        return new StasisFieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).filter(Objects::nonNull).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        permanent.removeAllAbilities(source.getSourceId(), game);
        permanent.addAbility((Ability)DefenderAbility.getInstance(), source.getSourceId(), game);
        return true;
    }
}

