/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.cards.CardSetInfo;
import mage.cards.SplitCard;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SpellAbilityType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class StatusStatue
extends SplitCard {
    private static final FilterPermanent filter = new FilterPermanent("artifact, creature, or enchantment");

    public StatusStatue(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{B/G}", "{2}{B}{G}", SpellAbilityType.SPLIT);
        this.getLeftHalfCard().getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 1, Duration.EndOfTurn).setText("Target creature gets +1/+1"));
        this.getLeftHalfCard().getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance(), Duration.EndOfTurn).setText("and gains deathtouch until end of turn"));
        this.getLeftHalfCard().getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getRightHalfCard().getSpellAbility().addTarget((Target)new TargetPermanent(filter));
    }

    private StatusStatue(StatusStatue card) {
        super((SplitCard)card);
    }

    public StatusStatue copy() {
        return new StatusStatue(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate()}));
    }
}

