/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class StewardOfTheHarvestEffect
extends ContinuousEffectImpl {
    List<Ability> abilities = new ArrayList<Ability>();
    ExileZone lastZone;

    public StewardOfTheHarvestEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Creatures you control have all activated abilities of all land cards exiled with this creature.";
    }

    private StewardOfTheHarvestEffect(StewardOfTheHarvestEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.abilities = effect.abilities;
        this.lastZone = effect.lastZone;
    }

    public StewardOfTheHarvestEffect copy() {
        return new StewardOfTheHarvestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)CardUtil.getActualSourceObjectZoneChangeCounter((Game)game, (Ability)source));
        ExileZone exile = game.getExile().getExileZone(exileId);
        if (exile != null) {
            this.lastZone = exile;
            if (this.abilities.isEmpty()) {
                exile.getCards(game).stream().map(card -> card.getAbilities(game)).flatMap(Collection::stream).filter(ability -> ability instanceof ActivatedAbility).forEach(ability -> this.abilities.add((Ability)ability));
            }
        } else {
            this.abilities.clear();
            if (this.lastZone != null) {
                this.lastZone.getCards(game).forEach(card -> game.getExile().moveToMainExileZone(card, game));
            }
        }
        List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
        for (Ability ability2 : this.abilities) {
            for (Permanent creature : creatures) {
                creature.addAbility(ability2, source.getSourceId(), game);
            }
        }
        return true;
    }
}

