/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.StickTogetherTarget;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class StickTogetherEffect
extends OneShotEffect {
    StickTogetherEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses a party from among creatures they control, then sacrifices the rest";
    }

    private StickTogetherEffect(StickTogetherEffect effect) {
        super((OneShotEffect)effect);
    }

    public StickTogetherEffect copy() {
        return new StickTogetherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet toKeep = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            StickTogetherTarget target = new StickTogetherTarget();
            player.choose(this.outcome, (Target)target, source, game);
            toKeep.addAll(target.getTargets());
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (toKeep.contains(creature.getId())) continue;
            creature.sacrifice(source, game);
        }
        return true;
    }
}

