/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class StickTogetherTarget
extends TargetPermanent {
    private static final SubTypeAssignment subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.CLERIC, SubType.ROGUE, SubType.WARRIOR, SubType.WIZARD});
    private static final FilterPermanent filterParty = new FilterControlledPermanent("a party");

    StickTogetherTarget() {
        super(0, 4, filterParty, true);
    }

    private StickTogetherTarget(StickTogetherTarget target) {
        super((TargetPermanent)target);
    }

    public StickTogetherTarget copy() {
        return new StickTogetherTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (!super.canTarget(playerId, id, ability, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(id);
        if (permanent == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add((Card)permanent);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        possibleTargets.removeIf(uuid -> !this.canTarget(sourceControllerId, (UUID)uuid, source, game));
        return possibleTargets;
    }

    static {
        filterParty.add(Predicates.or((Predicate[])new Predicate[]{SubType.CLERIC.getPredicate(), SubType.ROGUE.getPredicate(), SubType.WARRIOR.getPredicate(), SubType.WIZARD.getPredicate()}));
    }
}

