/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockingOrBlockedWatcher;

enum StingTheGlintingDaggerCondition implements Condition
{
    instance;

    public static final FilterPermanent filterOrcOrGoblin;

    public boolean apply(Game game, Ability source) {
        Permanent sting = game.getPermanent(source.getSourceId());
        if (sting == null) {
            return false;
        }
        Permanent equippedCreature = game.getPermanent(sting.getAttachedTo());
        if (equippedCreature == null) {
            return false;
        }
        if (equippedCreature.isAttacking() && equippedCreature.isBlocked(game)) {
            UUID controllerId = equippedCreature.getControllerId();
            return game.getBattlefield().getActivePermanents(filterOrcOrGoblin, controllerId, game).stream().anyMatch(p -> BlockingOrBlockedWatcher.check((Permanent)equippedCreature, (Permanent)p, (Game)game));
        }
        if (equippedCreature.getBlocking() > 0) {
            UUID controllerId = equippedCreature.getControllerId();
            return game.getBattlefield().getActivePermanents(filterOrcOrGoblin, controllerId, game).stream().anyMatch(p -> BlockingOrBlockedWatcher.check((Permanent)p, (Permanent)equippedCreature, (Game)game));
        }
        return false;
    }

    static {
        filterOrcOrGoblin = new FilterCreaturePermanent();
        filterOrcOrGoblin.add(Predicates.or((Predicate)SubType.GOBLIN.getPredicate(), (Predicate)SubType.ORC.getPredicate()));
    }
}

