/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class StingingStudyEffect
extends OneShotEffect {
    StingingStudyEffect() {
        super(Outcome.Benefit);
        this.staticText = "you draw X cards and you lose X life, where X is the mana value of a commander you own on the battlefield or in the command zone";
    }

    private StingingStudyEffect(StingingStudyEffect effect) {
        super((OneShotEffect)effect);
    }

    public StingingStudyEffect copy() {
        return new StingingStudyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int chosenValue;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<Integer> manaValues = new HashSet<Integer>();
        for (Card commander : game.getCommanderCardsFromAnyZones(player, CommanderCardType.ANY, new Zone[]{Zone.BATTLEFIELD, Zone.COMMAND})) {
            manaValues.add(commander.getManaValue());
        }
        if (manaValues.size() > 1) {
            ChoiceImpl choice = new ChoiceImpl(true);
            choice.setChoices(manaValues.stream().map(x -> "" + x).collect(Collectors.toSet()));
            player.choose(this.outcome, (Choice)choice, game);
            chosenValue = Integer.parseInt(choice.getChoice());
        } else {
            chosenValue = manaValues.stream().findFirst().orElse(0);
        }
        if (chosenValue == 0) {
            return false;
        }
        player.drawCards(chosenValue, source, game);
        player.loseLife(chosenValue, game, source, false);
        return true;
    }
}

