/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StockingThePantryTriggeredAbility
extends TriggeredAbilityImpl {
    StockingThePantryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.SUPPLY.createInstance()));
        this.setTriggerPhrase("Whenever you put one or more +1/+1 counters on a creature you control, ");
    }

    private StockingThePantryTriggeredAbility(StockingThePantryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public StockingThePantryTriggeredAbility copy() {
        return new StockingThePantryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName()) || !this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && permanent.isControlledBy(this.getControllerId());
    }
}

