/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;

class StonebindersFamiliarTriggeredAbility
extends TriggeredAbilityImpl {
    StonebindersFamiliarTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.setTriggersLimitEachTurn(1);
    }

    private StonebindersFamiliarTriggeredAbility(StonebindersFamiliarTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.EXILED && this.isControlledBy(game.getActivePlayerId()) && (zEvent.getFromZone() != Zone.BATTLEFIELD || !(zEvent.getTarget() instanceof PermanentToken));
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile during your turn, put a +1/+1 counter on {this}. This ability triggers only once each turn.";
    }

    public StonebindersFamiliarTriggeredAbility copy() {
        return new StonebindersFamiliarTriggeredAbility(this);
    }
}

