/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class StonehewerGiantEffect
extends OneShotEffect {
    StonehewerGiantEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "search your library for an Equipment card, put it onto the battlefield, attach it to a creature you control, then shuffle";
    }

    private StonehewerGiantEffect(StonehewerGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public StonehewerGiantEffect copy() {
        return new StonehewerGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard("Equipment");
        filter.add((Predicate)SubType.EQUIPMENT.getPredicate());
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        if (controller.searchLibrary(target, source, game) && (card = controller.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            Permanent equipment = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            TargetControlledCreaturePermanent targetCreature = new TargetControlledCreaturePermanent();
            targetCreature.withNotTarget(true);
            if (equipment != null && controller.choose(Outcome.BoostCreature, (Target)targetCreature, source, game)) {
                Permanent permanent = game.getPermanent(targetCreature.getFirstTarget());
                permanent.addAttachment(equipment.getId(), source, game);
            }
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

