/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StormOfSoulsChangeCreatureEffect
extends ContinuousEffectImpl {
    StormOfSoulsChangeCreatureEffect() {
        super(Duration.Custom, Outcome.Benefit);
    }

    private StormOfSoulsChangeCreatureEffect(StormOfSoulsChangeCreatureEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (UUID cardID : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(cardID);
            if (permanent == null) continue;
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.SPIRIT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(1);
                    permanent.getToughness().setModifiedBaseValue(1);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public StormOfSoulsChangeCreatureEffect copy() {
        return new StormOfSoulsChangeCreatureEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }
}

