/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StormchaserChimeraEffect
extends OneShotEffect {
    StormchaserChimeraEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then reveal the top card of your library. {this} gets +X/+0 until end of turn, where X is that card's mana value";
    }

    private StormchaserChimeraEffect(StormchaserChimeraEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player == null || sourcePermanent == null) {
            return false;
        }
        if (player.getLibrary().hasCards()) {
            Card card = player.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            player.revealCards(sourcePermanent.getName(), (Cards)cards, game);
            if (card != null) {
                game.addEffect((ContinuousEffect)new BoostSourceEffect(card.getManaValue(), 0, Duration.EndOfTurn), source);
                return true;
            }
        }
        return false;
    }

    public StormchaserChimeraEffect copy() {
        return new StormchaserChimeraEffect(this);
    }
}

