/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StormsplitterEffect
extends OneShotEffect {
    StormsplitterEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of {this}. Exile that token at the beginning of the next end step";
    }

    private StormsplitterEffect(StormsplitterEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormsplitterEffect copy() {
        return new StormsplitterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setSavedPermanent(permanent);
        effect.apply(game, source);
        effect.exileTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

