/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StormwildCapridorEffect
extends PreventionEffectImpl {
    StormwildCapridorEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If noncombat damage would be dealt to {this}, prevent that damage. Put a +1/+1 counter on {this} for each 1 damage prevented this way";
    }

    private StormwildCapridorEffect(StormwildCapridorEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public StormwildCapridorEffect copy() {
        return new StormwildCapridorEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionEffectData = this.preventDamageAction(event, source, game);
        if (preventionEffectData.getPreventedDamage() > 0) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(preventionEffectData.getPreventedDamage()), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getTargetId().equals(source.getSourceId()) || !super.applies(event, source, game)) {
            return false;
        }
        DamageEvent damageEvent = (DamageEvent)event;
        return !damageEvent.isCombatDamage();
    }
}

