/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class StoryweaveWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    StoryweaveWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        EntersTheBattlefieldEvent zEvent = (EntersTheBattlefieldEvent)event;
        if (zEvent.getTarget().isEnchantment(game) && zEvent.getTarget().isCreature(game)) {
            this.playerMap.compute(zEvent.getPlayerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    static int getCounter(Game game, Ability source) {
        return ((StoryweaveWatcher)game.getState().getWatcher(StoryweaveWatcher.class)).playerMap.getOrDefault(source.getControllerId(), 0);
    }
}

