/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StrictProctorTriggeredAbility
extends TriggeredAbilityImpl {
    StrictProctorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CounterUnlessPaysEffect((Cost)new GenericManaCost(2)));
    }

    private StrictProctorTriggeredAbility(StrictProctorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRIGGERED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getTargetId());
        if (stackObject == null) {
            return false;
        }
        Ability ability = stackObject.getStackAbility();
        if (!ability.isTriggeredAbility()) {
            return false;
        }
        GameEvent triggerEvent = ((TriggeredAbility)ability).getTriggerEvent();
        if (triggerEvent == null || triggerEvent.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        return true;
    }

    public StrictProctorTriggeredAbility copy() {
        return new StrictProctorTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a permanent entering the battlefield causes a triggered ability to trigger, counter that ability unless its controller pays {2}.";
    }
}

