/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.StructuralAssaultWatcher;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StructuralAssaultEffect
extends OneShotEffect {
    StructuralAssaultEffect() {
        super(Outcome.Damage);
        this.staticText = ", then {this} deals damage to each creature equal to the number of artifacts that were put into graveyards from the battlefield this turn";
    }

    private StructuralAssaultEffect(StructuralAssaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public StructuralAssaultEffect copy() {
        return new StructuralAssaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int artifacts;
        StructuralAssaultWatcher watcher = (StructuralAssaultWatcher)game.getState().getWatcher(StructuralAssaultWatcher.class);
        if (watcher != null && (artifacts = watcher.getArtifactsDied()) > 0) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
                permanent.damage(artifacts, source, game);
            }
            return true;
        }
        return false;
    }
}

