/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class StubbornBurrowFiendWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> saddledCount = new HashMap<MageObjectReference, Integer>();

    StubbornBurrowFiendWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.MOUNT_SADDLED) {
            return;
        }
        this.saddledCount.compute(new MageObjectReference(event.getTargetId(), game), CardUtil::setOrIncrementValue);
    }

    public int timesSaddledThisTurn(MageObjectReference mor) {
        return this.saddledCount.getOrDefault(mor, 0);
    }

    public void reset() {
        super.reset();
        this.saddledCount.clear();
    }
}

