/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class StunningReversalEffect
extends ReplacementEffectImpl {
    StunningReversalEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next time you would lose the game this turn, instead draw seven cards and your life total becomes 1";
    }

    private StunningReversalEffect(StunningReversalEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public StunningReversalEffect copy() {
        return new StunningReversalEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            player.drawCards(7, source, game);
            player.setLife(1, game, source);
            this.discard();
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOSES;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }
}

