/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class StuntedGrowthEffect
extends OneShotEffect {
    StuntedGrowthEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player chooses three cards from their hand and puts them on top of their library in any order";
    }

    private StuntedGrowthEffect(StuntedGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public StuntedGrowthEffect copy() {
        return new StuntedGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            int possibleNumber = Math.min(3, targetPlayer.getHand().size());
            if (possibleNumber > 0) {
                TargetCardInHand target = new TargetCardInHand(possibleNumber, new FilterCard("cards from your hand"));
                targetPlayer.choose(this.outcome, (Target)target, source, game);
                CardsImpl cards = new CardsImpl();
                for (UUID cardId : target.getTargets()) {
                    Card card = game.getCard(cardId);
                    if (card == null) continue;
                    cards.add(card);
                }
                targetPlayer.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

