/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class SuddenReclamationEffect
extends OneShotEffect {
    SuddenReclamationEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then return a creature card and a land card from your graveyard to your hand";
    }

    private SuddenReclamationEffect(SuddenReclamationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuddenReclamationEffect copy() {
        return new SuddenReclamationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            CardsImpl cardsToHand = new CardsImpl();
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
            target.withNotTarget(true);
            if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                cardsToHand.add(card);
            }
            target = new TargetCardInYourGraveyard((FilterCard)new FilterLandCard("land card from your graveyard"));
            target.withNotTarget(true);
            if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                cardsToHand.add(card);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

