/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.util.CardUtil;

class SufferThePastEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card from target player's graveyard");

    SufferThePastEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exile X target cards from target player's graveyard. For each card exiled this way, that player loses 1 life and you gain 1 life";
    }

    private SufferThePastEffect(SufferThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SufferThePastEffect copy() {
        return new SufferThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (you == null || targetPlayer == null) {
            return false;
        }
        int numberToTarget = Math.min(targetPlayer.getGraveyard().size(), (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0));
        if (numberToTarget < 1) {
            return false;
        }
        TargetCardInOpponentsGraveyard target = new TargetCardInOpponentsGraveyard(numberToTarget, numberToTarget, filter);
        if (target.canChoose(source.getControllerId(), source, game) && target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game)) {
            int numberExiled = 0;
            for (UUID targetId : target.getTargets()) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                you.moveCards(card, Zone.EXILED, source, game);
                ++numberExiled;
            }
            you.gainLife(numberExiled, game, source);
            targetPlayer.loseLife(numberExiled, game, source, false);
        }
        return true;
    }
}

