/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class SummaryDismissalEffect
extends OneShotEffect {
    SummaryDismissalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile all other spells and counter all abilities";
    }

    private SummaryDismissalEffect(SummaryDismissalEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummaryDismissalEffect copy() {
        return new SummaryDismissalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<StackObject> stackList = new ArrayList<StackObject>();
        for (StackObject stackObject : game.getStack()) {
            if (stackObject.getSourceId().equals(source.getSourceId())) continue;
            stackList.add(stackObject);
        }
        for (StackObject stackObject : stackList) {
            if (stackObject instanceof Spell) {
                ((Spell)stackObject).moveToExile(null, "", null, game);
            }
            if (!(stackObject instanceof Ability)) continue;
            game.getStack().counter(stackObject.getId(), source, game);
        }
        return true;
    }
}

