/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.condition.common.AddendumCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SummaryJudgementEffect
extends OneShotEffect {
    SummaryJudgementEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to target tapped creature.<br><i>Addendum</i> &mdash; If you cast this spell during your main phase, it deals 5 damage instead.";
    }

    private SummaryJudgementEffect(SummaryJudgementEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummaryJudgementEffect copy() {
        return new SummaryJudgementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int damage = 3;
        if (AddendumCondition.instance.apply(game, source)) {
            damage = 5;
        }
        return permanent.damage(damage, source.getSourceId(), source, game) > 0;
    }
}

