/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;

class SummonKujataEffect
extends OneShotEffect {
    SummonKujataEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard a card, then draw two cards. When you discard a card this way, this creature deals damage equal to that card's mana value to each opponent";
    }

    private SummonKujataEffect(SummonKujataEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonKujataEffect copy() {
        return new SummonKujataEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discard(1, false, false, source, game).getRandom(game);
        player.drawCards(2, source, game);
        if (card != null) {
            game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new DamagePlayersEffect(card.getManaValue(), TargetController.OPPONENT), false), source);
        }
        return true;
    }
}

