/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SagaAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterOpponentsCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

public final class SummonShiva
extends CardImpl {
    private static final FilterPermanent filter = new FilterOpponentsCreaturePermanent("tapped creature your opponents control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public SummonShiva(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT, CardType.CREATURE}, "{3}{U}{U}");
        this.subtype.add((Object)SubType.SAGA);
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.power = new MageInt(4);
        this.toughness = new MageInt(5);
        SagaAbility sagaAbility = new SagaAbility((Card)this);
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_I, SagaChapter.CHAPTER_II, ability -> {
            ability.addEffect((Effect)new TapTargetEffect());
            ability.addEffect((Effect)new AddCountersTargetEffect(CounterType.STUN.createInstance()).setText("Put a stun counter on it"));
            ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
            ability.withFlavorWord("Heavenly Strike");
        });
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_III, ability -> {
            ability.addEffect((Effect)new DrawCardSourceControllerEffect(xValue));
            ability.withFlavorWord("Diamond Dust");
            ability.addHint(hint);
        });
        this.addAbility((Ability)sagaAbility);
    }

    private SummonShiva(SummonShiva card) {
        super((CardImpl)card);
    }

    public SummonShiva copy() {
        return new SummonShiva(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
        xValue = new PermanentsOnBattlefieldCount(filter, Integer.valueOf(1));
        hint = new ValueHint("Tapped creatures your opponents control", xValue);
    }
}

