/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SummonersEggImprintEffect
extends OneShotEffect {
    SummonersEggImprintEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile a card from your hand face down";
    }

    private SummonersEggImprintEffect(SummonersEggImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            Card card;
            TargetCard target;
            if (!controller.getHand().isEmpty() && (target = new TargetCard(Zone.HAND, StaticFilters.FILTER_CARD)).canChoose(source.getControllerId(), source, game) && controller.choose(Outcome.Benefit, controller.getHand(), target, source, game) && (card = controller.getHand().get(target.getFirstTarget(), game)) != null) {
                card.setFaceDown(true, game);
                controller.moveCardsToExile(card, source, game, false, source.getSourceId(), sourcePermanent.getIdName() + " (Imprint)");
                card.setFaceDown(true, game);
                sourcePermanent.imprint(card.getId(), game);
                sourcePermanent.addInfo("imprint", CardUtil.addToolTipMarkTags((String)"[Imprinted card]"), game);
            }
            return true;
        }
        return false;
    }

    public SummonersEggImprintEffect copy() {
        return new SummonersEggImprintEffect(this);
    }
}

