/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SummonsOfSarumanEffect
extends OneShotEffect {
    SummonsOfSarumanEffect() {
        super(Outcome.Benefit);
        this.staticText = "Mill X cards. You may cast an instant or sorcery spell with mana value X or less from among them without paying its mana cost. <i>(To amass Orcs X, put X +1/+1 counters on an Army you control. It's also an Orc. If you don't control an Army, create a 0/0 black Orc Army creature token first.)</i>";
    }

    private SummonsOfSarumanEffect(SummonsOfSarumanEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonsOfSarumanEffect copy() {
        return new SummonsOfSarumanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        if (player == null || xValue < 1) {
            return false;
        }
        Cards cards = player.millCards(xValue, source, game);
        cards.retainZone(Zone.GRAVEYARD, game);
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        return true;
    }
}

