/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class SunbirdEffigyEffect
extends ManaEffect {
    SunbirdEffigyEffect() {
        this.staticText = "for each color among the exiled cards used to craft {this}, add one mana of that color";
    }

    private SunbirdEffigyEffect(SunbirdEffigyEffect effect) {
        super((ManaEffect)effect);
    }

    public SunbirdEffigyEffect copy() {
        return new SunbirdEffigyEffect(this);
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source, (int)-2));
        if (exileZone == null) {
            return mana;
        }
        ObjectColor color = exileZone.getCards(game).stream().map(card -> card.getColor(game)).reduce(new ObjectColor(), ObjectColor::union);
        if (color.isWhite()) {
            mana.increaseWhite();
        }
        if (color.isBlue()) {
            mana.increaseBlue();
        }
        if (color.isBlack()) {
            mana.increaseBlack();
        }
        if (color.isRed()) {
            mana.increaseRed();
        }
        if (color.isGreen()) {
            mana.increaseGreen();
        }
        return mana;
    }
}

