/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SuncleanserPreventCountersEffect
extends ContinuousRuleModifyingEffectImpl {
    SuncleanserPreventCountersEffect(boolean player) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = player ? "That player can't get counters for as long as {this} remains on the battlefield." : "It can't have counters put on it for as long as {this} remains on the battlefield";
    }

    private SuncleanserPreventCountersEffect(SuncleanserPreventCountersEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SuncleanserPreventCountersEffect copy() {
        return new SuncleanserPreventCountersEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.getFirstTarget().equals(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            this.discard();
            return false;
        }
        return true;
    }
}

