/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SunderTheGatewayEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.INCUBATOR, "Incubator token you control");

    SunderTheGatewayEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then transform an Incubator token you control";
    }

    private SunderTheGatewayEffect(SunderTheGatewayEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunderTheGatewayEffect copy() {
        return new SunderTheGatewayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.transform(source, game);
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

