/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SunderingTitanDestroyLandEffect
extends OneShotEffect {
    SunderingTitanDestroyLandEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "choose a land of each basic land type, then destroy those lands";
    }

    private SunderingTitanDestroyLandEffect(SunderingTitanDestroyLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunderingTitanDestroyLandEffect copy() {
        return new SunderingTitanDestroyLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        HashSet<UUID> lands = new HashSet<UUID>();
        if (controller != null && sourcePermanent != null) {
            for (SubType landName : SubType.getBasicLands()) {
                FilterLandPermanent filter = new FilterLandPermanent(landName + " to destroy");
                filter.add((Predicate)landName.getPredicate());
                TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
                if (!target.canChoose(source.getControllerId(), source, game)) continue;
                controller.chooseTarget(this.outcome, (Target)target, source, game);
                lands.add(target.getFirstTarget());
            }
            if (!lands.isEmpty()) {
                int destroyedLands = 0;
                for (UUID landId : lands) {
                    Permanent land = game.getPermanent(landId);
                    if (land == null || !land.destroy(source, game, false)) continue;
                    ++destroyedLands;
                }
                game.informPlayers(sourcePermanent.getLogName() + ": " + destroyedLands + (destroyedLands > 1 ? " lands were" : "land was") + " destroyed");
            }
            return true;
        }
        return false;
    }
}

