/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SunfrillImitatorAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class SunfrillImitatorEffect
extends OneShotEffect {
    private static final CopyApplier copyApplier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.setName("Sunfrill Imitator");
            blueprint.getAbilities().add((Object)new SunfrillImitatorAbility());
            return true;
        }
    };

    public SunfrillImitatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may have it become a copy of another target Dinosaur you control, except its name is Sunfrill Imitator and it has this ability.";
    }

    private SunfrillImitatorEffect(SunfrillImitatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (targetPermanent != null && sourcePermanent != null) {
            game.copyPermanent(Duration.EndOfGame, targetPermanent, sourcePermanent.getId(), source, copyApplier);
            return true;
        }
        return false;
    }

    public SunfrillImitatorEffect copy() {
        return new SunfrillImitatorEffect(this);
    }
}

