/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class SunpearlKirinEffect
extends OneShotEffect {
    SunpearlKirinEffect() {
        super(Outcome.Benefit);
        this.staticText = "return up to one other target nonland permanent you control to its owner's hand. If it was a token, draw a card";
    }

    private SunpearlKirinEffect(SunpearlKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunpearlKirinEffect copy() {
        return new SunpearlKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        boolean isToken = permanent instanceof PermanentToken;
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (isToken) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

