/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SunscourgeChampionEffect
extends OneShotEffect {
    SunscourgeChampionEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain life equal to its power.";
    }

    private SunscourgeChampionEffect(SunscourgeChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && permanent != null) {
            controller.gainLife(permanent.getPower().getValue(), game, source);
            return true;
        }
        return false;
    }

    public SunscourgeChampionEffect copy() {
        return new SunscourgeChampionEffect(this);
    }
}

