/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.dynamicvalue.common.SourceControllerCountersCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SuppressionRayTargetEffect
extends OneShotEffect {
    SuppressionRayTargetEffect() {
        super(Outcome.Tap);
        this.staticText = "Tap all creatures target player controls. You may pay X {E}, then choose up to X creatures tapped this way. Put a stun counter on each of them.";
    }

    private SuppressionRayTargetEffect(SuppressionRayTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuppressionRayTargetEffect copy() {
        return new SuppressionRayTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        ArrayList<MageObjectReference> tappedThisWay = new ArrayList<MageObjectReference>();
        for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
            if (creature.isTapped()) continue;
            creature.tap(source, game);
            if (!creature.isTapped()) continue;
            tappedThisWay.add(new MageObjectReference((MageObject)creature, game));
        }
        int maxEnergy = SourceControllerCountersCount.ENERGY.calculate(game, source, (Effect)this);
        if (maxEnergy == 0) {
            return true;
        }
        int numberToPay = controller.getAmount(0, maxEnergy, "How many {E} do you like to pay? (" + tappedThisWay.size() + " creature(s) were tapped)", source, game);
        if (numberToPay == 0) {
            return true;
        }
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        if (cost.pay(source, game, source, source.getControllerId(), true)) {
            FilterPermanent filter = new FilterPermanent("creature tapped this way");
            filter.add((Predicate)new PermanentReferenceInCollectionPredicate(tappedThisWay));
            TargetPermanent target = new TargetPermanent(0, numberToPay, filter, true);
            target.choose(Outcome.Tap, controller.getId(), source.getSourceId(), source, game);
            List toPutStunCounterOn = target.getTargets().stream().map(id -> new MageObjectReference(id, game)).collect(Collectors.toList());
            if (!toPutStunCounterOn.isEmpty()) {
                new AddCountersTargetEffect(CounterType.STUN.createInstance()).setTargetPointer((TargetPointer)new FixedTargets(toPutStunCounterOn)).apply(game, source);
            }
        }
        return true;
    }
}

