/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SurgeOfSalvationEffect
extends PreventionEffectImpl {
    SurgeOfSalvationEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that black and/or red sources would deal to creatures you control this turn";
    }

    private SurgeOfSalvationEffect(SurgeOfSalvationEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public SurgeOfSalvationEffect copy() {
        return new SurgeOfSalvationEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        MageObject sourceObject = game.getObject(event.getSourceId());
        return permanent != null && sourceObject != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId()) && (sourceObject.getColor(game).isBlack() || sourceObject.getColor(game).isRed());
    }
}

